{
:title "Markdown Syntax Guide"
:date "2020-01-03"
:description "Sample article showcasing basic Markdown syntax and formatting for HTML elements."
:tags ["markdown" "syntax"]
:published true
}
%%%

For a thorough guide to markdown, check out [cmark-gfm guide][1], which our markdown->html renderer is based on.

**Note:** bagatto uses [markable][2] for markdown->html rendering. The default rendering options and extensions in bagatto are missing some important options such as tables, tasklist, etc.
In order to render all those elements, more options are added to the render function. See `post.temple` and `page.temple` files in the `partials` directory.

---

This is a showoff of basic Markdown syntax that can be used in bagatto content
files (see the relevant file with .md extension in the content dir).
Here you see the rendering of those elements with current bear css.

## Headings

The following HTML `<h1>`—`<h6>` elements represent six levels of section headings. `<h1>` is the highest section level while `<h6>` is the lowest.
Notice that `<h2>`—`<h3>` have `id` tags and anchor (hover over them to see), because we manipulate the resulting html and add these elements. See `index.janet` file for the details.

# H1
## H2
### H3
#### H4
##### H5
###### H6

## Paragraph

Artisanal[^2] bridge refrigerator hacker, dolphin camera convenience store rain drone. Numinous tower sensory 8-bit digital decay rifle 3D-printed, sub-orbital render-farm nodal point systema. DIY papier-mache futurity face forwards long-chain hydrocarbons: assassin neon alcohol Shibuya modem Legba.

Military-grade rain jeans pre- decay market voodoo god sensory artisanal jeans fetishism. Claymore mine saturation point rain, neural table fluidity A.I. wonton soup carbon digital monofilament. Rebar youtube franchise alcohol assassin paranoid sentient skyscraper towards physical.

[^2]: Text generated with [loremgibson](http://loremgibson.com/)

## Blockquotes

The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a `footer` or `cite` element, and optionally with in-line changes such as annotations and abbreviations.

#### Blockquote without attribution

> Urban j-pop girl warehouse tanto tube semiotics receding.
> **Note** that you can use *Markdown syntax* within a blockquote.

#### Blockquote with attribution

> Don't communicate by sharing memory, share memory by communicating.<br>
> — <cite>Rob Pike[^1]</cite>

[^1]: The above quote is excerpted from Rob Pike's [talk](https://www.youtube.com/watch?v=PAAkCSZUG1c) during Gopherfest, November 18, 2015.

## Tables

Tables aren't part of the core Markdown spec, but [markable][2] supports them out-of-the-box.

|   Name | Age  |
|--------|------|
|    Bob | 27   |
|  Alice | 23   |

#### Inline Markdown within tables

| Italics   | Bold     | Code   |
| --------  | -------- | ------ |
| *italics* | **bold** | `code` |

## Code Blocks

#### Code block with backticks

```html
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Example HTML5 Document</title>
</head>
<body>
  <p>Test</p>
</body>
</html>
```

#### Code block indented with four spaces

    <!doctype html>
    <html lang="en">
    <head>
      <meta charset="utf-8">
      <title>Short HTML5 Document</title>
    </head>
    <body>
      <p>Another test</p>
    </body>
    </html>

## List Types

#### Ordered List

1. First item
2. Second item
3. Third item

#### Unordered List

* List item
* Another item
* And another item

#### Nested list

* Fruit
  * Apple
  * Orange
  * Banana
* Dairy
  * Milk
  * Cheese

## Links

Here is a link to the [end of the internet][11], which is somewhere on the net..

And here is a link to this here page, just [another section][12] of it!
Although cmark-gfm (this is the markdown->html renderer bagatto uses under the hood)
doesn't support adding `id` attributes to elements, we are using the power of janet
to add `id` attribute for headings, look at `index.janet` for the code.

## Other Elements — abbr, sub, sup, kbd, mark

<abbr title="Graphics Interchange Format">GIF</abbr> is a bitmap image format.

H<sub>2</sub>O

X<sup>n</sup> + Y<sup>n</sup> = Z<sup>n</sup>

Press <kbd><kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>Delete</kbd></kbd> to end the session.

Most <mark>salamanders</mark> are nocturnal, and hunt for insects, worms, and other small creatures.

---

[1]: https://github.github.com/gfm/
[2]: https://github.com/pyrmont/markable
[11]: https://hmpg.net/
[12]: #tables
