# Bagatto ʕ•ᴥ•ʔ Bear Blog

🧸 A [Bagatto][1] theme based on [Hugo Bear Blog][2], which in turn
is based on the original [Bear blog][3].

> Free, no-nonsense, super-fast blogging.

This README is based on the original text from [Hugo Bear Blog][2], I just changed things where needed.

## Demo

For a current & working demo of this theme, check it out [right here][10] 🎯.

## Screenshots

⬜️ [Light][light-screenshot]

⬛️ [Dark][dark-screenshot]

When the user's browser is running »dark mode«, the dark color scheme will be used automatically. The default is the light/white color scheme. Check out the `style.temple` file in the `templates/partials` directory for the implementation.

## Installation

1. Make sure you have [bagatto][1] somewhere on your path. If not, follow the guide on the bagatto site and compile it. You should end up with `bag` executable.
2. Download or clone this repo.
3. Adjust the `index.janet` file to your liking.
4. Go thru the `templates` directory, adjust the templates as needed.
5. And finally, start changing the files in the `content` dir, and add your own by copy/paste existing ones and changing their contents.

For a deep dive on what is possible with bagatto, [RTFM][4] of bagatto.

## Local vs Webserver

In order to make developing and watching the site locally as simple as possible (i.e. no need for local webserver), all the generated urls are relative. This means that when you open any generated site file in a browser, everything works as if running a webserver.

An exception to the rule is when an url points to a directory, then you will get a list of files in that directory. That is because a webserver will first look for a file named `index.html` in a directory and serve that, while a browser won't. That is a matter of personal preference (and webserver). If you want to directly point to `index.html` files, change here:

1. Change `data :config :menus` in `index.janet` to point directly at `index.html` files
2. Change the 'Remove filter' link in `templates/partials/tag.temple` to point at `../index.html` file

There is an option to use `<base>` tag with your site base url. It is commented by default. If needed, un-comment it at `partials/head.temple`, but remember that it will be harder to test the generated site locally, so do it just before deployment.

## Adding your branding / colors / css

Check out the `style.temple` file in the `templates/partials` directory, to find out which CSS-styles are applied by default. The css styles are inlined with the html in order to save network requests. You can change this file, or add your own in `custom_head.temple` file to your `templates/partials` directory. In there you may add a `<style>` tag, *or* you may add a `<link>` tag referencing your own `custom.css` (in case you prefer to have a separate `.css` file, but remember we try to minimize network access). 

## Development 

In the directory which contains the file `index.janet` run the next command to render the site

```bash
bag index.janet
```

It is possible to debug the process by using janet repl

```bash
bag index.janet --repl
```

Some unique points related to the use of [janet][8], which enables us to do the following:

- Control the whole site generation process from one file - `index.janet`, while using janet scripting language and power.
- Manipulate the resulting html by using PEGs. For example, headings (h2, h3) are manipulated by adding `id` tags and anchor links. This will enable the construction of TOC for long posts (not done yet..)
- Processing of tags, creating a beautiful tag list page, instead of tag 'cloud'.

## Get the code
Here are your options:
1. clone the repo with `fossil clone https://hdrz.cc/museum/bagatto-bearblog/ /local-repo.fossil`
2. Download [`tar.gz`][11] archive of the latest commit.
3. Download [`zip`][12] archive of the latest commit.
4. On the [timeline][13] page, choose the check-in you want and then download or clone.

## Contributing & Community 🤝

Interested in contributing to bagatto ʕ•ᴥ•ʔ Bear Blog? Thanks for your interest!

- This is a small effort by one person, working in my free time.
- Remember: This should stay as minimal and fast as possible. I view this as a starting point for customized and personal site.
- I would love to hear from you if you have anything to add/remove (preferably remove..).

## Special Thanks 🎁

A special thank you goes out to [Herman][5], for creating the original [ʕ•ᴥ•ʔ Bear Blog][3], and to [Jan Raasch][6] for porting the blog to hugo.

## License
[MIT License][7] © [Jan Raasch][6], [hdrz][9]

[1]: https://bagatto.co/
[2]: https://github.com/janraasch/hugo-bearblog
[3]: https://bearblog.dev/ 
[4]: https://bagatto.co/manual
[5]: https://herman.bearblog.dev
[6]: https://www.janraasch.com
[7]: https://en.wikipedia.org/wiki/MIT_License
[8]: https://janet-lang.org/
[9]: https://hdrz.cc
[10]: site/
[11]: https://hdrz.cc/museum/bagatto-bearblog/tarball/bagatto-bearblog.tar.gz
[12]: https://hdrz.cc/museum/bagatto-bearblog/zip/bagatto-bearblog.zip
[13]: https://hdrz.cc/museum/bagatto-bearblog/timeline
[light-screenshot]: static/images/light.png
[dark-screenshot]: static/images/dark.png
